#!/usb/opt/ActiveTcl-8.5/bin/tclsh8.5

package require Tk
package require tile

namespace eval ::pres:: {
}

#----------
# GUI

namespace eval ::gui:: {
    variable _gui
    array set _gui {
        initialized 0
    }
    # exported procedures
    namespace export make_page
    namespace export show_page
}

# _init
#       called once when package is read
proc ::gui::_init {} {
    variable _gui
    if {$_gui(initialized)} {
        return
    }
    _make_styles
    _create_nb
    set _gui(initialized) 1
}

#----------------------------------------------------------------------
# internal stuff, done on init

proc ::gui::_make_styles {} {
    # font for takahashi-style presentation
    font create ftaka -family "Bitstream Charter" -size 48
    ::ttk::style theme settings default {
        # a style for the labels containing the presentation, Takahashi-style
        ::ttk::style configure Ltaka.TLabel -font ftaka -background #a08040 -anchor c
        # a style for notebooks without tabs
        ::ttk::style layout NoTabs.TNotebook.Tab null
    }
}

proc ::gui::_create_nb {} {
    ::ttk::notebook .n -style NoTabs.TNotebook
    pack .n -expand yes -fill both
    bind . <1> {::gui::next_page +1}
    bind . <Key> {::gui::next_page +1}
    bind . <Escape> {exit}
    bind . <Right> {::gui::next_page +1}
    bind . <Up> {::gui::next_page -1}
    bind . <Left> {::gui::next_page -1}
    bind . <BackSpace> {::gui::next_page -1}
}

#----------------------------------------------------------------------
# publicly usable procedures

namespace eval ::gui:: {
    variable _pages
    variable _cur
}

proc ::gui::make_page {w} {
    variable _pages
    .n add $w
    lappend _pages $w
}

proc ::gui::show_page {w} {
    if {$w ne ""} {
	variable _cur
	.n select $w
	set _cur $w
    }
}

proc ::gui::next_page {idx} {
    variable _pages
    variable _cur
    set i [lsearch -exact $_pages $_cur]
    set i [expr $i $idx]
    # puts "showing $_cur gonna show [lindex $_pages $i]"
    show_page [lindex $_pages $i]
}

proc ::gui::do_exit {} {
    exit
}

#----------------------------------------------------------------------

proc ::pres::make_slide {str} {
    variable cnt
    set n [incr cnt]
    set f [::ttk::frame .slide_$n]
    ::ttk::label $f.l -text $str -style Ltaka.TLabel
    pack $f.l -expand 1 -fill both
    ::gui::make_page $f
}

proc ::pres::load_file {fname} {
    set f [open $fname r]
    set lines [read $f]
    close $f
    foreach line [split $lines \n] {
	make_slide $line
    }
    ::gui::show_page .slide_1
}

#======

::gui::_init
::pres::load_file $argv

